/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.traitements.fonctionsPKCS11.general;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class InfoLibrairie {
    private static Logger log = Logger.getLogger(InfoLibrairie.class);

    public static Resultat traitementP11(PKCS11 pKCS11) throws ExceptionTraitement {
        try {
            if (pKCS11 != null) {
                ResultatInfo resultatInfo = new ResultatInfo("Obtenir des informations sur la librairie (C_GetInfo)");
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                resultatInfo.setInfos(linkedHashMap);
                try {
                    CK_INFO cK_INFO = pKCS11.C_GetInfo();
                    if (cK_INFO == null) {
                        log.error((Object)"L'operation a retourne des informations nulles");
                        throw new ExceptionTraitement(1, "L'op\u00e9ration a retourn\u00e9 des informations nulles");
                    }
                    linkedHashMap.put("Version de la librairie", cK_INFO.libraryVersion.toString());
                    linkedHashMap.put("Identifiant de la biblioth\u00e8que du fabricant", new String(cK_INFO.manufacturerID));
                    linkedHashMap.put("Description de la librairie", new String(cK_INFO.libraryDescription));
                    linkedHashMap.put("Version de l\u2019impl\u00e9mentation de la librairie", cK_INFO.cryptokiVersion.toString());
                }
                catch (PKCS11Exception pKCS11Exception) {
                    log.info((Object)("Operation echouee : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                    resultatInfo.setCodeRetour(pKCS11Exception.getErrorCode());
                }
                return resultatInfo;
            }
            log.error((Object)"La librairie est nulle");
            throw new ExceptionTraitement(1, "La librairie est nulle");
        }
        catch (Throwable throwable) {
            if (throwable instanceof ExceptionTraitement) {
                throw (ExceptionTraitement)throwable;
            }
            log.error((Object)("Une erreur inattendue est survenue : " + ExceptionProgrammeExemple.getStacktrace(throwable)));
            throw new ExceptionTraitement(1, "Une erreur inattendue est survenue");
        }
    }
}

